/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import wayoftime.bloodmagic.common.container.tile.ContainerTeleposer;
import wayoftime.bloodmagic.common.item.ITeleposerFocus;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.TileInventory;
import wayoftime.bloodmagic.core.data.SoulNetwork;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.util.Utils;
import wayoftime.bloodmagic.util.helper.NetworkHelper;

public class TileTeleposer
extends TileInventory
implements MenuProvider,
CommandSource {
    int previousInput = 0;
    public static final int FOCUS_SLOT = 0;
    public static final int MAX_UNIT_COST = 1000;
    public static final int MAX_TOTAL_COST = 10000;

    public TileTeleposer(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, 1, "teleposer", pos, state);
    }

    public TileTeleposer(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.TELEPOSER_TYPE.get(), pos, state);
    }

    public void tick() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        int currentInput = this.m_58904_().m_46751_(this.f_58858_);
        if (this.previousInput == 0 && currentInput != 0) {
            this.previousInput = currentInput;
            this.initiateTeleport();
        } else {
            this.previousInput = currentInput;
        }
    }

    public void initiateTeleport() {
        if (!(this.f_58857_ instanceof ServerLevel)) {
            return;
        }
        if (!this.canTeleport()) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)this.f_58857_;
        ItemStack focusStack = this.m_8020_(0);
        ITeleposerFocus focusItem = (ITeleposerFocus)focusStack.m_41720_();
        Level linkedWorld = focusItem.getStoredWorld(focusStack, this.f_58857_);
        BlockPos linkedPos = focusItem.getStoredPos(focusStack);
        if (linkedWorld == null || linkedPos.equals((Object)this.f_58858_)) {
            return;
        }
        ResourceKey linkedKey = linkedWorld.m_46472_();
        BlockEntity boundTile = linkedWorld.m_7702_(linkedPos);
        if (boundTile instanceof TileTeleposer) {
            Vec3 newPosVec;
            AABB entityRangeOffsetBB = focusItem.getEntityRangeOffset(linkedWorld, this.m_58899_());
            if (entityRangeOffsetBB == null) {
                return;
            }
            double transportCost = Math.min(0.5 * Math.sqrt(linkedPos.m_123331_((Vec3i)this.f_58858_)), 1000.0);
            if (!linkedWorld.equals(this.f_58857_)) {
                transportCost = 1000.0;
            }
            AABB originalBB = entityRangeOffsetBB.m_82338_(this.m_58899_());
            AABB focusBB = entityRangeOffsetBB.m_82338_(linkedPos);
            List originalEntities = this.f_58857_.m_45976_(Entity.class, originalBB);
            List focusEntities = this.f_58857_.m_45976_(Entity.class, focusBB);
            List<BlockPos> offsetList = focusItem.getBlockListOffset(this.f_58857_);
            int uses = 0;
            int maxUses = offsetList.size() + originalEntities.size() + focusEntities.size();
            int maxDrain = Math.min((int)(transportCost * (double)maxUses), 10000);
            SoulNetwork network = this.getNetwork();
            if (network.getCurrentEssence() < maxDrain) {
                return;
            }
            for (Entity entity : originalEntities) {
                newPosVec = entity.m_20182_().m_82492_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()).m_82520_((double)linkedPos.m_123341_(), (double)linkedPos.m_123342_(), (double)linkedPos.m_123343_());
                if (entity instanceof Player && !linkedWorld.equals(this.f_58857_)) {
                    this.teleportPlayerToLocation(serverWorld, (Player)entity, (ResourceKey<Level>)linkedKey, newPosVec.f_82479_, newPosVec.f_82480_, newPosVec.f_82481_);
                } else {
                    entity.m_6021_(newPosVec.f_82479_, newPosVec.f_82480_, newPosVec.f_82481_);
                    entity.f_19853_ = linkedWorld;
                }
                ++uses;
            }
            for (Entity entity : focusEntities) {
                newPosVec = entity.m_20182_().m_82520_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()).m_82492_((double)linkedPos.m_123341_(), (double)linkedPos.m_123342_(), (double)linkedPos.m_123343_());
                if (entity instanceof Player && !linkedWorld.equals(this.f_58857_)) {
                    this.teleportPlayerToLocation(serverWorld, (Player)entity, (ResourceKey<Level>)this.f_58857_.m_46472_(), newPosVec.f_82479_, newPosVec.f_82480_, newPosVec.f_82481_);
                } else {
                    entity.m_6021_(newPosVec.f_82479_, newPosVec.f_82480_, newPosVec.f_82481_);
                    entity.f_19853_ = this.f_58857_;
                }
                ++uses;
            }
            for (BlockPos offsetPos : offsetList) {
                BlockPos focusPos;
                BlockPos originalPos = this.f_58858_.m_141952_((Vec3i)offsetPos);
                if (!Utils.swapLocations(this.f_58857_, originalPos, linkedWorld, focusPos = linkedPos.m_141952_((Vec3i)offsetPos), false)) continue;
                ++uses;
            }
            this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), SoundEvents.f_11852_, SoundSource.BLOCKS, 1.0f, 1.0f);
            linkedWorld.m_6263_(null, (double)linkedPos.m_123341_(), (double)linkedPos.m_123342_(), (double)linkedPos.m_123343_(), SoundEvents.f_11852_, SoundSource.BLOCKS, 1.0f, 1.0f);
            network.syphon(SoulTicket.block(this.f_58857_, this.f_58858_, Math.min((int)((double)uses * transportCost), 10000)));
        }
    }

    public boolean canTeleport() {
        SoulNetwork network = this.getNetwork();
        return network != null;
    }

    private SoulNetwork getNetwork() {
        ItemStack focusStack = this.m_8020_(0);
        if (!focusStack.m_41619_() && focusStack.m_41720_() instanceof ITeleposerFocus) {
            return NetworkHelper.getSoulNetwork(((ITeleposerFocus)focusStack.m_41720_()).getBinding(focusStack));
        }
        return null;
    }

    @Override
    public void deserialize(CompoundTag tagCompound) {
        super.deserialize(tagCompound);
        this.previousInput = tagCompound.m_128451_("redstone");
    }

    @Override
    public CompoundTag serialize(CompoundTag tagCompound) {
        super.serialize(tagCompound);
        tagCompound.m_128405_("redstone", this.previousInput);
        return tagCompound;
    }

    public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
        assert (this.f_58857_ != null);
        return new ContainerTeleposer(this, p_createMenu_1_, p_createMenu_2_);
    }

    public Component m_5446_() {
        return new TextComponent("Teleposer");
    }

    public CommandSourceStack getCommandSource(ServerLevel world) {
        return new CommandSourceStack((CommandSource)this, new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()), Vec2.f_82462_, world, 2, "Teleposer", (Component)new TextComponent("Teleposer"), world.m_142572_(), (Entity)null);
    }

    public void teleportPlayerToLocation(ServerLevel serverWorld, Player player, ResourceKey<Level> destination, double x, double y, double z) {
        String command = this.getTextCommandForTeleport(destination, player, x, y, z);
        MinecraftServer mcServer = serverWorld.m_142572_();
        mcServer.m_129892_().m_82117_(this.getCommandSource(serverWorld), command);
    }

    public String getTextCommandForTeleport(ResourceKey<Level> destination, Player player, double posX, double posY, double posZ) {
        String playerName = player.m_7755_().getString();
        return "execute in " + destination.m_135782_().toString() + " run teleport " + playerName + " " + posX + " " + posY + " " + posZ;
    }

    public void m_6352_(Component component, UUID senderUUID) {
    }

    public boolean m_6999_() {
        return false;
    }

    public boolean m_7028_() {
        return false;
    }

    public boolean m_6102_() {
        return false;
    }
}

